import { getDataFun } from '@/request/method';
import { router } from '@/router';
import { ElMessage } from 'element-plus';

let permissionInterval = null;
let previousPermissionData = null;

/**
 * 开始权限轮询检查
 * @param {Number} interval - 轮询间隔，默认10000ms
 */
export function startPermissionCheck(interval = 5000) {
  // // 如果已经存在轮询，先清除
  // if (permissionInterval) {
  //   clearInterval(permissionInterval);
  // }

  // // 初始化获取一次权限数据
  // checkUserPermission();

  // // 设置定时轮询
  // permissionInterval = setInterval(() => {
  //   checkUserPermission();
  // }, interval);
}

/**
 * 停止权限轮询检查
 */
export function stopPermissionCheck() {
  if (permissionInterval) {
    clearInterval(permissionInterval);
    permissionInterval = null;
  }
}

/**
 * 检查用户权限
 */
async function checkUserPermission() {
  try {
    const response = await getDataFun('/management/admin/userDataPermission', {
      userId: sessionStorage.getItem('userId') || 1
    });
    
    // 如果请求成功
    if (response && response.code === 1) {
      const currentPermissionData = JSON.stringify(response.data);
      
      // 将当前权限数据存储到 sessionStorage
      sessionStorage.setItem('userPermission', currentPermissionData);
      
      // 如果之前有权限数据，比较是否有变化
      if (previousPermissionData && previousPermissionData !== currentPermissionData) {
        // 权限发生变化，退出登录
        ElMessage({
          type: 'warning',
          message: '您的权限已变更，系统将自动退出登录',
          duration: 2000,
          onClose: () => {
            logout();
          }
        });
      }
      
      // 更新之前的权限数据
      previousPermissionData = currentPermissionData;
    }
  } catch (error) {
    console.error('权限检查失败:', error);
  }
}

/**
 * 退出登录
 */
function logout() {
  // 清除所有相关的存储数据
  localStorage.removeItem('menuList');
  sessionStorage.removeItem('userPermission');
  // 可能还有其他需要清除的数据，如 token 等
  
  // 跳转到登录页
  router.push('/login');
}

export default {
  startPermissionCheck,
  stopPermissionCheck
}; 