import { defineConfig, loadEnv } from 'vite'
import vue from '@vitejs/plugin-vue'
import path from "path" // 需安装此模块
import { fileURLToPath, URL } from 'node:url'

// https://vite.dev/config/
export default defineConfig(({mode}) => {
  const ENV = loadEnv(mode, process.cwd())
  return {
    base: './',  // 基础路径配置
    plugins: [vue()],
    resolve: {
      alias: {
        // 这里就是需要配置resolve里的别名
        "@": fileURLToPath(new URL('./src', import.meta.url))
      }
    },
    build: {
      outDir: 'dist', // 指定输出目录
      assetsDir: 'assets', // 指定静态资源存放目录
      sourcemap: false, // 不生成 sourcemap 文件
      chunkSizeWarningLimit: 1500, // 文件大小警告的限制（kbs）
      rollupOptions: {
        output: {
          chunkFileNames: 'assets/js/[name]-[hash].js',
          entryFileNames: 'assets/js/[name]-[hash].js',
          assetFileNames: 'assets/[ext]/[name]-[hash].[ext]',
          manualChunks(id) {
            if (id.includes('node_modules')) {
              return 'vendor'
            }
          }
        }
      }
    },
    server: {
      host: '0.0.0.0', // 指定服务器主机名
      port: 3000, // 指定服务器端口
      proxy: {
        [ENV.VITE_APP_BASE_API5]: {
          target: 'https://screen.bmetech.com',  // 更新为完整的基础路径
          changeOrigin: true,
          rewrite: (path) => path.replace(/^\/api/, '')  // 添加路径重写规则
        },
      }
    }
  }
})
