import { color } from "echarts";

export const getLineOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
  },
  grid: {
    left: "3%",
    right: "4%",
    bottom: "15%",
    top: "5%",
    containLabel: true,
  },
  legend: {
    data: ["健康度指数（%）"],
    bottom: "0%",
    icon: "circle",
    itemWidth: 10,
    itemHeight: 10,
    itemGap: 10,
  },
  xAxis: {
    type: "category",
    axisTick: {
      show: false,
    },
    axisLine: {
      lineStyle: {
        color: "#E9ECF2",
      },
    },
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
    },
    splitLine: {
      lineStyle: {
        color: "#E9ECF2",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: "健康度指数（%）",
      type: "line",
      color: "#399DFA",
      data: seriesData,
      smooth: true,
    },
  ],
});

export const getDustLineOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
  },
  grid: {
    left: "3%",
    right: "4%",
    bottom: "15%",
    top: "5%",
    containLabel: true,
  },
  legend: {
    data: ["健康度指数（%）"],
    bottom: "0%",
    icon: "circle",
    itemWidth: 10,
    itemHeight: 10,
    itemGap: 10,
  },
  xAxis: {
    type: "category",
    axisTick: {
      show: false,
    },
    axisLine: {
      lineStyle: {
        color: "#E9ECF2",
      },
    },
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
    },
    splitLine: {
      lineStyle: {
        color: "#E9ECF2",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: "",
      type: "line",
      color: "#399DFA",
      data: seriesData,
      smooth: true,
    },
  ],
});

// 布袋监测图表配置
export const getBagMonitoringChartOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
    axisPointer: {
      type: "line",
      lineStyle: {
        color: "#6E7079",
        width: 1,
      },
    },
  },
  grid: {
    left: "20",
    right: "20",
    bottom: "30",
    top: "3%",
    containLabel: true,
  },
  xAxis: {
    type: "category",
    boundaryGap: false,
    axisLine: {
      lineStyle: {
        color: "#E9ECF2",
      },
    },
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
      fontSize: 12,
      interval: "auto",
      rotate: 0,
    },
    axisTick: {
      show: false,
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    min: 0,
    max: 600,
    interval: 200,
    axisLabel: {
      color: "rgba(0,0,0,0.6)",
      formatter: "{value}",
    },
    splitLine: {
      lineStyle: {
        color: "#E9ECF2",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: "监测值",
      type: "line",
      smooth: false,
      symbol: "none",
      sampling: "average",
      itemStyle: {
        color: "#7B68EE",
      },
      lineStyle: {
        width: 1,
      },
      areaStyle: {
        color: {
          type: "linear",
          x: 0,
          y: 0,
          x2: 0,
          y2: 1,
          colorStops: [
            {
              offset: 0,
              color: "rgba(123, 104, 238, 0.4)",
            },
            {
              offset: 1,
              color: "rgba(123, 104, 238, 0.1)",
            },
          ],
        },
      },
      data: seriesData,
    },
  ],
});
