# Cypress 测试启动指导

## 问题解决

你遇到的 `cy.visit() failed trying to load: http://localhost:5173/login` 错误已经修复。主要修复包括：

### 1. 路由修复
项目使用 Hash 路由模式，正确的 URL 格式应该是：
- ✅ `/#/login` (正确)
- ❌ `/login` (错误)

### 2. 权限控制处理
项目有路由守卫，需要 localStorage 中有 `menuList` 才能访问非登录页面。现在测试中使用 `cy.mockLogin()` 来模拟登录状态。

## 启动步骤

### 1. 启动开发服务器
```bash
npm run dev
```
确保服务器在 `http://localhost:5173` 启动

### 2. 运行 Cypress 测试

**选项A: 图形界面模式**
```bash
npm run cy:open
```

**选项B: 无头模式运行**
```bash
npm run cy:run
```

### 3. 验证修复

现在运行登录测试应该能够：
1. 正确访问 `/#/login` 页面
2. 显示登录表单元素
3. 处理路由守卫逻辑

## 测试覆盖

修复后的测试套件包括：

### 📋 登录功能 (`login.cy.js`)
- ✅ 登录页面元素显示
- ✅ 表单验证
- ✅ 密码可见性切换
- ✅ 验证码处理
- ✅ 路由守卫测试

### 📊 仪表板功能 (`dashboard.cy.js`) 
- ✅ 核心组件渲染
- ✅ 健康度指标
- ✅ 图表和地图组件
- ✅ 响应式布局

### 📋 除尘器概览 (`dust-overview.cy.js`)
- ✅ 数据表格
- ✅ 搜索筛选
- ✅ 操作按钮
- ✅ 分页功能

### 🧭 导航菜单 (`navigation.cy.js`)
- ✅ 菜单显示
- ✅ 路由跳转
- ✅ 权限控制

## 注意事项

1. **确保开发服务器已启动**: 测试前必须先运行 `npm run dev`
2. **Hash 路由**: 所有 URL 都需要包含 `#` 符号
3. **权限模拟**: 使用 `cy.mockLogin()` 设置必要的 localStorage 数据
4. **网络请求**: 测试可能会产生实际的 API 请求，考虑使用 cy.intercept() 进行模拟

现在你可以重新运行 Cypress 测试，登录功能测试应该能够正常工作了！