import * as echarts from "echarts";

        // 设置图表主题颜色
        const chartColors = {
          background: '#181d21',
          textColor: '#8a9199',
          axisLineColor: '#2a2f33',
          splitLineColor: '#2a2f33',
          blue: '#4e7bfa',
          teal: '#36f1cd',
          green: '#36f1cd',
          yellow: '#f5b83d',
          red: '#ff4d4d',
          purple: '#6366f1'
      };
      
      // 通用图表配置
      const commonConfig = {
          backgroundColor: chartColors.background,
          textStyle: {
              color: chartColors.textColor
          },
          legend: {
              icon: 'circle',
              textStyle: {
                  color: chartColors.textColor
              }
          },
          xAxis: {
              axisLine: {
                  lineStyle: {
                      color: chartColors.axisLineColor
                  }
              },
              axisLabel: {
                  color: chartColors.textColor
              },
              splitLine: {
                  lineStyle: {
                      color: chartColors.splitLineColor,
                      type: 'dashed'
                  }
              }
          },
          yAxis: {
              axisLine: {
                  lineStyle: {
                      color: chartColors.axisLineColor
                  }
              },
              axisLabel: {
                  color: chartColors.textColor
              },
              nameTextStyle: {
                  color: chartColors.textColor
              },
              splitLine: {
                  lineStyle: {
                      color: chartColors.splitLineColor,
                      type: 'dashed'
                  }
              }
          },
          tooltip: {
              backgroundColor: 'rgba(24, 29, 33, 0.9)',
              borderColor: '#2a2f33',
              textStyle: {
                  color: '#fff'
              }
          }
      };
      
export const getLineOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
    backgroundColor: 'rgba(24, 29, 33, 0.9)',
    borderColor: '#2a2f33',
    textStyle: {
        color: '#fff'
    }
  },
  
  grid: {
    left: "3%",
    right: "4%",
    bottom: "15%",
    top: "5%",
    containLabel: true,
  },
  legend: {
    data: ["健康度指数（%）"],
    bottom: "0%",
    icon: "circle",
    itemWidth: 10,
    itemHeight: 10,
    itemGap: 10,
    textStyle: {
      color: '#fff'
    }
  },
  xAxis: {
    type: "category",
    axisTick: {
      show: false,
    },
    axisLine: {
      lineStyle: {
        color: "#3a3f45",
      },
    },
    axisLabel: {
      color: "#909399",
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    axisLabel: {
      color: "#909399",
    },
    splitLine: {
      lineStyle: {
        color: "#3a3f45",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: "健康度指数（%）",
      type: "line",
      color: "#399DFA",
      data: seriesData,
      smooth: true,
    },
  ],
});

export const getDustLineOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
  },
  grid: {
    left: "3%",
    right: "4%",
    bottom: "15%",
    top: "5%",
    containLabel: true,
  },
  legend: {
    data: ["周期(天数)"],
    bottom: "0%",
    itemWidth: 20,
    itemHeight: 10,
    itemGap: 10,
    textStyle: {
      color: '#fff'
    }
  },
  xAxis: {
    type: "category",
    axisTick: {
      show: false,
    },
    axisLine: {
      lineStyle: {
        color: "#3a3f45",
      },
    },
    axisLabel: {
      color: "#909399",
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    axisLabel: {
      color: "#909399",
    },
    splitLine: {
      lineStyle: {
        color: "#3a3f45",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: "周期(天数)",
      type: "line",
      color: "#399DFA",
      data: seriesData,
      smooth: true,
    },
  ],
});

// 布袋监测图表配置
export const getBagMonitoringChartOption = (xData = [], seriesData = []) => ({
  tooltip: {
    trigger: "axis",
    ...commonConfig.tooltip,
  },
  grid: {
    left: "20",
    right: "20",
    bottom: "30",
    top: "3%",
    containLabel: true,
  },
  // x轴的文字去除年月日
  xAxis: {
    type: "category",
    boundaryGap: false,
    axisLabel: {
      color: chartColors.textColor,
      fontSize: 12,
      interval: "auto",
      rotate: 0,
      formatter: function (value) {
        return value.split(' ')[1];
      }
    },
    axisLine: {
      lineStyle: {
        color: "#3a3f45",
      },
    },

    axisTick: {
      show: false,
    },

    data: xData,
  },
  yAxis: {
    type: "value",
    min: 0,
    // max: 600,
    // interval: 200,
    axisLabel: {
      formatter: "{value}",
      ...commonConfig.yAxis.axisLabel
    },
    ...commonConfig.yAxis
  },
  series: [
    {
      name: "监测值",
      type: "line",
      smooth: true,
      symbol: 'circle',
      symbolSize: 0,
      lineStyle: {
          width: 2,
          color: chartColors.teal
      },
      itemStyle: {
          color: chartColors.teal
      },
      areaStyle: {
        color: {
          type: "linear",
          x: 0,
          y: 0,
          x2: 0,
          y2: 1,
          colorStops: [
            {
              offset: 0,
              color: "rgba(54, 241, 205, 0.8)",
            },
            {
              offset: 1,
              color: "rgba(54, 241, 205, 0)",
            },
          ],
        },
      },

      data: seriesData,
    },
  ],
});

export const getLineOption2 = (xData = [], seriesData = [], legendDesc = "健康度指数（%）") => ({
  tooltip: {
    trigger: "axis",
    backgroundColor: 'rgba(24, 29, 33, 0.9)',
    borderColor: 'rgba(255, 255, 255, 0.1)',
    borderWidth: 2,
    textStyle: {
        color: '#fff'
    }
  },
  grid: {
    left: "70",
    right: "50",
    bottom: "30",
    top: "30",
  },
  legend: {
    data: [legendDesc],
    top: "0%",
    icon: "circle",
    itemWidth: 10,
    itemHeight: 10,
    itemGap: 10,
    textStyle: {
      color: '#fff'
    }
  },
  xAxis: {
    type: "category",
    axisTick: {
      show: false,
    },
    axisLine: {
      lineStyle: {
        color: "#3a3f45",
      },
    },
    axisLabel: {
      color: "#909399",
    },
    data: xData,
  },
  yAxis: {
    type: "value",
    axisLabel: {
      color: "#909399",
    },
    splitLine: {
      lineStyle: {
        color: "#3a3f45",
        type: "dashed",
      },
    },
  },
  series: [
    {
      name: legendDesc,
      type: "line",
      color: "#399DFA",
      data: seriesData,
      smooth: true,
    },
  ],
});

export const getGaugeOption = (option) => {
  return {
    series: [
      {
        type: "gauge",
        startAngle: 220,
        endAngle: 320,
        center: ["50%", "50%"],
        radius: "90%",
        min: option.min || 0,
        max: option.max || 100,
        splitNumber: 8,
        axisLine: {
          lineStyle: {
            width: 30,
            color: [
              [0.2, "#fd666d"],
              [0.8, "#48cd4d"],
              [1, "#fd666d"],
            ],
          },
        },
        pointer: {
          itemStyle: {
            color: 'auto',
          }
        },
        axisTick: {
          distance: -30,
          length: 10,
          lineStyle: {
            color: "#909399",
            width: 2,
          },
        },
        splitLine: {
          distance: -30,
          length: 38,
          lineStyle: {
            color: '#909399',
            width: 2
          },
          
        },
        axisLabel: {
          color: '#909399',
          fontSize: 10,
          distance: 30,
          rotate: "tangential",
          formatter: option.formatter || "{value}",
        },
        title: {
          offsetCenter: [0, "70%"],
          fontSize: 14,
          fontWeight: "bolder",
          color: "#fff"
        },
        detail: {
          fontSize: 20,
          offsetCenter: [0, 40],
          valueAnimation: true,
          formatter: function (value) {
            return value;
          },
          color: "#fff",
        },
        data: [
          {
            value: option.value || 0,
            name: option.chartName || '',
          },
        ],
      },
    ],
  };
}