// cypress/e2e/generic-login.cy.js
describe('通用登录测试', () => {
  beforeEach(() => {
    cy.visit('https://screen.bmetech.com/admin/dctom/')
  })

  it('应该能够成功登录', () => {
    // 使用环境变量中的凭据登录
    const username = Cypress.env('username')
    const password = Cypress.env('password')
    
    cy.get('[data-testid="login-username-input"]').type(username)
    cy.get('[data-testid="login-password-input"]').type(password)
    cy.get('[data-testid="login-captcha-input"]').type('8888')
    cy.get('[data-testid="login-submit-button"]').click()
    
    // 验证登录成功（根据实际应用调整）
    cy.url().should('not.include', '/login')
    cy.get('[data-testid="dashboard-container"]').should('be.visible')
  })
})