describe('template spec', () => {
  it('DC-TOM告警总览', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('https://screen.bmetech.com/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zongheng_admin');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear('9%#F46vt');
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"] > span').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    
    cy.get('[data-testid="menu-item-alerts"] > span').click();
    
    // 等待告警页面API请求完成
    cy.waitForAPIs(2000);
    // 执行搜索操作
    cy.get('[data-testid="event-name-input"]').clear('t');
    cy.get('[data-testid="event-name-input"]').type('提升阀');
    cy.get('[data-testid="search-button"]').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    
    cy.get('[data-testid="location-input"]').click();
    cy.get('[data-testid="location-input"]').clear('2');
    cy.get('[data-testid="location-input"]').type('2#除尘系统');
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    
    cy.get('[data-testid="duster-name-input"]').clear('1');
    cy.get('[data-testid="duster-name-input"]').type('1#除尘系统');
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    // 测试设备类型选择
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-0').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-1').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-2').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    // 测试挂起设备功能
    cy.get('[data-testid="suspend-device-button"] > span').click();
    cy.get('[data-testid="menu-item-alerts"]').click();
    
    // 等待挂起相关API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="suspend-flag-radio-during"] > .el-radio__label').click();
    cy.get('[data-testid="suspend-flag-radio-during"] > .el-radio__input > .el-radio__original').check();
    cy.get('[data-testid="suspend-flag-radio-all"] > .el-radio__label').click();
    cy.get('[data-testid="suspend-flag-radio-all"] > .el-radio__input > .el-radio__original').check();
    
    // 添加兼容性检查，判断是否存在suspend-action-link元素
    cy.get('body').then($body => {
      // 检查是否存在suspend-action-link元素
      if ($body.find('[data-testid="cell-0-operate"] > [data-testid="suspend-action-link"]').length) {
        cy.get('[data-testid="cell-0-operate"] > [data-testid="suspend-action-link"]').click();
        cy.get('.el-dialog__headerbtn > .el-icon > svg').click();
      }
    });
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})