describe('template spec', () => {
  it('DC-TOM除尘器总览', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('https://screen.bmetech.com/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zo');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear();
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"]').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    cy.get('[data-testid="menu-item-dust-overview"] > span').click();
    
    // 等待除尘器总览页面API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="dust-leak-alert-card"] > .title').click();
    
    // 等待告警相关API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="menu-item-dust-overview"]').click();
    cy.get('[data-testid="dust-close-loop-card"] > img').click();
    
    // 等待闭环相关API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="menu-item-dust-overview"] > span').click();
    cy.get('[data-testid="dust-production-line-select"] > .el-select__wrapper').click();
    cy.get('#production-line-option-1').click();
    cy.get('[data-testid="dust-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="dust-reset-button"] > span').click();
    cy.get('[data-testid="dust-device-name-input"]').clear('1');
    cy.get('[data-testid="dust-device-name-input"]').type('1#除尘系统');
    cy.get('[data-testid="dust-search-button"]').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    cy.get('[data-testid="dust-add-button"] > span').click();
    
    // 等待新增弹窗API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="cancel-button"]').click();
    cy.get('[data-testid="compartment-count-link"]').click();
    
    // 等待仓室详情API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="dialog-footer"] > [data-testid="confirm-button"] > span').click();
    cy.get('[data-testid="valve-count-link"]').click();
    
    // 等待阀门详情API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="save-button"] > span').click();
    cy.get('.status-matrix > :nth-child(1) > :nth-child(1)').click();
    
    // 等待状态矩阵API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="menu-item-dust-overview"] > span').click();

    // 添加兼容性检查，判断是否存在操作按钮元素
    cy.get('body').then($body => {
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="dust-view-button"]').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="dust-view-button"]').click();
        
        // 等待查看详情API请求完成
        cy.waitForAPIs(2000);
        
        cy.get('[data-testid="menu-item-dust-overview"] > span').click();
      }   
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="dust-edit-button"]').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="dust-edit-button"]').click();
        
        // 等待编辑弹窗API请求完成
        cy.waitForAPIs(2000);
        
        cy.get('[data-testid="confirm-button"]').click();
      }
    });
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})