describe('template spec', () => {
  it('DC-TOM除尘器监控', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('https://screen.bmetech.com/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zongheng_admin');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear('9%#F46vt');
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"]').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    cy.get('.el-select__wrapper').click();
    cy.get('[data-testid="duster-option-0"]').click();
    
    // 等待除尘器选择API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="compartment-health-matrix"] > :nth-child(1)').click();
    
    // 等待仓室点击API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="compartment-health-matrix"] > :nth-child(1) > :nth-child(1)').click();
    
    // 等待仓室详情API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="menu-item-monitor"]').click();
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})