describe('template spec', () => {
  it('EC-TOMPIKAR-烟尘识别数据台账', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('http://screen.bmetech.com/steelmakingScreen/#/smokeDustDetail');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行搜索操作
    cy.get('[data-testid="device-name-input"]').clear('1#出铁口');
    cy.get('[data-testid="device-name-input"]').type('1#出铁口');
    cy.get('[data-testid="query-button"] > span').click();
    
    // 等待API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    
    // 点击视频链接
    cy.get('[data-testid="cell-0-operate"] > [data-testid="watch-video-link"]').click();
    cy.get('.switchBtn > .el-button > span').click();
    
    // 等待视频相关API请求
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="cell-0-operate"] > [data-testid="data-detail-link"]').click();
    
    // 等待详情页面API请求
    cy.waitForAPIs(2000);
    
    // 判断是否有视频按钮，有则点击
    cy.get('body').then($body => {
      if ($body.find('[data-testid="video-button"]').length) {
        cy.get('[data-testid="video-button"]').click();
        cy.get('.switchBtn > .el-button > span').click();
        cy.get('[data-testid="back-button"]').click();
        
        // 等待视频播放相关API请求
        cy.waitForAPIs(2000);
      }
    });
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})