# DC-TOM 自动化测试操作手册

## 📋 目录
- [前提条件](#前提条件)
- [快速开始](#快速开始)
- [详细操作步骤](#详细操作步骤)
- [测试报告查看](#测试报告查看)
- [常见问题与解决方案](#常见问题与解决方案)
- [测试脚本说明](#测试脚本说明)

---

## 🔧 前提条件

### 系统要求
- Windows 10 或更高版本
- 已安装 Node.js (版本 14 或更高)
- 网络连接正常（需要访问测试环境）

### 环境检查
在开始测试前，请确认以下条件：
1. 测试环境可正常访问
2. 网络连接稳定
3. 浏览器（Chrome/Edge）已安装并可正常使用

---

## 🚀 快速开始

### 最简单的执行方式

1. **打开命令提示符**
   - 按 `Win + R` 键
   - 输入 `cmd` 并回车

2. **导航到项目目录**
   ```cmd
   cd /d "项目路径\dc-tom"
   ```

3. **执行测试**
   ```cmd
   run-tests.bat
   ```

4. **等待完成并查看报告**（测试完成后会显示报告路径）

---

## 📝 详细操作步骤

### 步骤 1：打开命令行工具

#### 方法一：使用 Windows 命令提示符
1. 按下 `Windows键 + R`
2. 在运行对话框中输入 `cmd`
3. 点击"确定"或按回车键

#### 方法二：使用 PowerShell
1. 按下 `Windows键 + X`
2. 选择"Windows PowerShell"

#### 方法三：在文件夹中直接打开
1. 打开文件资源管理器
2. 导航到 `dc-tom` 项目文件夹
3. 在地址栏中输入 `cmd` 并按回车

### 步骤 2：导航到项目目录

```cmd
cd /d "C:\path\to\your\dc-tom"
```

> 💡 **提示**：将上面的路径替换为您实际的项目路径

### 步骤 3：执行测试

#### 基本执行（推荐）
```cmd
run-tests.bat
```
- 默认使用 Chrome 浏览器
- 执行所有测试脚本
- 自动生成测试报告

#### 指定浏览器执行
```cmd
run-tests.bat chrome     # 使用 Chrome 浏览器
run-tests.bat edge       # 使用 Edge 浏览器
run-tests.bat electron   # 使用 Electron 浏览器（无界面）
```

### 步骤 4：观察测试执行过程

测试执行时，您将看到以下信息：

1. **初始化信息**
   ```
   开始执行测试，使用 chrome 浏览器
   使用固定配置运行测试，不依赖环境变量
   ```

2. **浏览器检查**
   ```
   检查浏览器 chrome-custom 是否可用...
   Using browser: chrome-custom
   ```

3. **清理旧报告**
   ```
   清理旧的报告文件...
   ```

4. **发现测试文件**
   ```
   - cypress\e2e\DC-TOM告警总览.cy.js
   - cypress\e2e\DC-TOM布袋周期.cy.js
   - cypress\e2e\DC-TOM我的闭环.cy.js
   ... (显示所有测试文件)
   ```

5. **执行测试**
   ```
   执行指定的测试脚本...
   ```
   - 此时会看到 Cypress 的详细测试日志
   - 每个测试的执行状态和结果

6. **生成报告**
   ```
   测试执行完成，退出码: 0
   测试执行成功，生成报告...
   找到 11 个JSON报告文件
   合并报告...
   生成HTML报告...
   生成自定义汇总报告...
   ```

### 步骤 5：测试完成确认

当看到以下信息时，表示测试已完成：

```
所有报告生成完成！
查看汇总报告: public\reports\summary-report.html
查看详细报告: public\reports\merged-report.html
测试执行完成
```

---

## 📊 测试报告查看

### 报告文件位置

测试完成后，报告文件位于以下位置：
```
dc-tom/
├── public/
│   └── reports/
│       ├── summary-report.html      # 汇总报告（推荐查看）
│       ├── merged-report.html       # 详细报告
│       └── merged-report.json       # 原始数据
```

### 查看汇总报告（推荐）

#### 方法一：双击打开
1. 打开文件资源管理器
2. 导航到 `dc-tom\public\reports\` 文件夹
3. 双击 `summary-report.html` 文件

#### 方法二：命令行打开
```cmd
start public\reports\summary-report.html
```

### 汇总报告内容说明

汇总报告包含以下关键信息：

1. **测试概览**
   - 总测试数量
   - 通过/失败数量
   - 测试执行时间
   - 整体通过率

2. **API监控统计**
   - API请求总数
   - API错误数量
   - 慢请求统计
   - API健康状态

3. **测试详情**
   - 每个测试脚本的执行结果
   - 失败测试的错误信息
   - 截图和视频（如有）

4. **性能指标**
   - 页面加载时间
   - API响应时间
   - 资源使用情况

### 查看详细报告

如需查看更详细的测试信息：

1. 打开 `public\reports\merged-report.html`
2. 包含完整的测试日志和步骤详情
3. 提供每个测试用例的详细执行过程

---

## ❗ 常见问题与解决方案

### 问题1：命令提示符中文显示乱码

**解决方案**：
```cmd
chcp 65001
```
然后重新执行测试脚本。

### 问题2：浏览器不可用

**现象**：
```
Browser chrome not found, falling back to electron
```

**解决方案**：
- 确保 Chrome 浏览器已安装
- 或使用其他浏览器：`run-tests.bat electron`

### 问题3：网络连接问题

**现象**：测试失败，提示网络超时

**解决方案**：
1. 检查网络连接
2. 确认测试环境可访问
3. 检查防火墙设置

### 问题4：Node.js 相关错误

**现象**：
```
'npx' 不是内部或外部命令
```

**解决方案**：
1. 确认 Node.js 已正确安装
2. 重启命令提示符
3. 检查环境变量配置

### 问题5：权限不足

**现象**：无法创建报告文件

**解决方案**：
1. 以管理员身份运行命令提示符
2. 检查项目文件夹的写入权限

### 问题6：测试卡住不动

**解决方案**：
1. 按 `Ctrl + C` 停止测试
2. 检查测试环境是否正常
3. 重新执行测试

---

## 📋 测试脚本说明

### 当前包含的测试脚本

| 测试脚本 | 功能描述 | 预计执行时间 |
|---------|---------|-------------|
| DC-TOM告警总览.cy.js | 告警管理功能测试 | 3-5分钟 |
| DC-TOM布袋周期.cy.js | 布袋周期管理测试 | 2-3分钟 |
| DC-TOM我的闭环.cy.js | 闭环流程测试 | 4-6分钟 |
| DC-TOM设备管理.cy.js | 设备管理功能测试 | 5-7分钟 |
| DC-TOM除尘器总览.cy.js | 除尘器总览测试 | 3-4分钟 |
| DC-TOM除尘器监控.cy.js | 除尘器监控测试 | 2-3分钟 |
| DC-TOM首页.cy.js | 首页功能测试 | 2-3分钟 |
| EC-TOME-Net.cy.js | E-Net系统测试 | 3-4分钟 |
| EC-TOMPIKAR烟尘识别数据台账.cy.js | 烟尘识别测试 | 3-4分钟 |
| EC-TOM准时化.cy.js | 准时化系统测试 | 4-5分钟 |
| EC-TOM设备数据台账.cy.js | 设备数据台账测试 | 3-4分钟 |

### 总预计执行时间：30-45分钟

---

## 🎯 测试最佳实践

### 执行前检查清单
- [ ] 确认测试环境可访问
- [ ] 网络连接稳定
- [ ] 关闭不必要的应用程序（释放系统资源）
- [ ] 确保有足够的磁盘空间（用于报告和截图）

### 执行过程中注意事项
1. **不要关闭命令提示符窗口**
2. **不要手动操作浏览器窗口**（如果出现）
3. **保持网络连接稳定**
4. **等待测试完全结束**再查看报告

### 测试结果解读
- **绿色/通过**：功能正常，无问题
- **红色/失败**：发现问题，需要关注
- **黄色/警告**：可能存在性能问题

---

## 📞 技术支持

如遇到无法解决的问题，请联系技术支持团队，并提供：
1. 错误信息截图
2. 测试报告文件
3. 执行环境信息（操作系统版本、浏览器版本等）

---

## 📝 更新日志

### v1.0.0 (当前版本)
- 初始版本
- 包含11个测试脚本
- 支持API监控和错误收集
- 自动生成HTML测试报告

---

*最后更新时间：2025年9月*
