describe('template spec', () => {
  it('DC-TOM我的闭环', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zongheng_admin');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear('9%#F46vt');
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"] > span').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    
    cy.get('[data-testid="menu-submenu-my-loop"] > .el-sub-menu__title > span').click();
    cy.get('[data-testid="menu-item-my-loop/myAgency"] > span').click();
    
    // 等待我的待办页面API请求完成
    cy.waitForAPIs(2000);
    cy.get('[data-testid="my-agency-event-name-input"]').clear('m');
    cy.get('[data-testid="my-agency-event-name-input"]').type('脉冲阀');
    cy.get('[data-testid="my-agency-search-button"]').click();
    cy.get('[data-testid="my-agency-reset-button"] > span').click();
    cy.get('[data-testid="my-agency-keyword-input"]').clear('2');
    cy.get('[data-testid="my-agency-keyword-input"]').type('2#除尘系统');
    cy.get('[data-testid="my-agency-search-button"] > span').click();
    cy.get('[data-testid="my-agency-reset-button"] > span').click();
    cy.get('[data-testid="my-agency-production-line-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#production-line-option-1').click();
    cy.get('[data-testid="my-agency-search-button"] > span').click();
    cy.get('[data-testid="my-agency-reset-button"] > span').click();
    cy.get('[data-testid="my-agency-device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-0').click();
    cy.get('[data-testid="my-agency-search-button"] > span').click();
    cy.get('[data-testid="my-agency-device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-1').click();
    cy.get('[data-testid="my-agency-search-button"] > span').click();
    cy.get('[data-testid="my-agency-device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-2').click();
    cy.get('[data-testid="my-agency-search-button"] > span').click();
    cy.get('[data-testid="my-agency-reset-button"]').click();
    
    // 添加兼容性检查，判断是否存在操作按钮元素
    cy.get('body').then($body => {
      // 处理流程按钮
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="my-agency-process-button"]').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="my-agency-process-button"]').click();
        cy.get('.el-dialog__headerbtn > .el-icon > svg').click();
      } 
      
      // 处理派单按钮
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="my-agency-dispatch-button"]').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="my-agency-dispatch-button"]').click();
        cy.get('[data-testid="assign-dialog"] > .el-dialog__header > .el-dialog__headerbtn > .el-icon > svg > path').click();
      }
      
      // 处理换袋按钮
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="my-agency-change-bag-button"]').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="my-agency-change-bag-button"]').click();
        cy.get('[data-testid="bag-dialog"] > .el-dialog__header > .el-dialog__headerbtn > .el-icon > svg').click();
      }
    });
    cy.get('[data-testid="menu-item-my-loop/myDone"] > span').click();
    cy.get('[data-testid="event-name-input"]').clear('t');
    cy.get('[data-testid="event-name-input"]').type('提升阀');
    cy.get('[data-testid="search-button"] > span').click();
    cy.get('[data-testid="reset-button"] > span').click();
    cy.get('[data-testid="location-input"]').clear('2');
    cy.get('[data-testid="location-input"]').type('2#除尘系统');
    cy.get('[data-testid="search-button"]').click();
    cy.get('[data-testid="reset-button"] > span').click();
    cy.get('[data-testid="production-line-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#production-line-option-1').click();
    cy.get('[data-testid="search-button"]').click();
    cy.get('[data-testid="reset-button"] > span').click();
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-0').click();
    cy.get('[data-testid="search-button"]').click();
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-1').click();
    cy.get('[data-testid="search-button"] > span').click();
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-2').click();
    cy.get('[data-testid="search-button"] > span').click();
    cy.get('[data-testid="reset-button"]').click();
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})