describe('template spec', () => {
  it('DC-TOM设备管理', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('https://screen.bmetech.com/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zongheng_admin');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear('9%#F46vt');
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"]').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    cy.get('[data-testid="menu-submenu-device-management"] > .el-sub-menu__title').click();
    cy.get('[data-testid="menu-item-management/device-management"] > span').click();
    
    // 等待设备管理页面API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-production-line-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#equipment-production-line-option-1').click();
    cy.get('[data-testid="equipment-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-reset-button"] > span').click();
    cy.get('[data-testid="equipment-duster-name-input"]').clear('2');
    cy.get('[data-testid="equipment-duster-name-input"]').type('2#除尘系统');
    cy.get('[data-testid="equipment-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-reset-button"] > span').click();
    cy.get('[data-testid="equipment-device-name-input"]').clear('bu');
    cy.get('[data-testid="equipment-device-name-input"]').type('布袋仪表');
    cy.get('[data-testid="equipment-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-reset-button"] > span').click();
    cy.get('[data-testid="equipment-device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#equipment-device-type-option-1').click();
    cy.get('[data-testid="equipment-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder > span').click();
    cy.get('#equipment-device-type-option-2').click();
    cy.get('[data-testid="equipment-search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="equipment-reset-button"] > span').click();
    
    // 添加兼容性检查，判断是否存在设备参数按钮
    cy.get('body').then($body => {
      // 检查原始选择器
      if ($body.find('[data-testid="cell-0-operation"] > [data-testid="equipment-params-button"] > span').length) {
        cy.get('[data-testid="cell-0-operation"] > [data-testid="equipment-params-button"] > span').click();
        
        // 等待参数弹窗API请求完成
        cy.waitForAPIs(2000);
        
        cy.get('[data-testid="confirm-button"]').click();
      }
    });
    cy.get('[data-testid="menu-item-management/suspend-management"] > span').click();
    
    // 等待挂起管理页面API请求完成
    cy.waitForAPIs(2000);
    cy.get('[data-testid="project-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#project-option-0').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder > span').click();
    cy.get('#device-type-option-0').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-1').click();
    cy.get('[data-testid="search-button"]').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="device-type-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#device-type-option-2').click();
    cy.get('[data-testid="search-button"]').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    cy.get('[data-testid="reason-category-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder').click();
    cy.get('#reason-category-option-1').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reason-category-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder > span').click();
    cy.get('#reason-category-option-2').click();
    cy.get('[data-testid="search-button"] > span').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reason-category-select"] > .el-select__wrapper > .el-select__selection > .el-select__placeholder > span').click();
    cy.get('#reason-category-option-3').click();
    cy.get('[data-testid="search-button"]').click();
    
    // 等待搜索API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="reset-button"] > span').click();
    // 添加兼容性检查，判断是否存在suspend-action-link元素
    cy.get('body').then($body => {
      // 检查是否存在suspend-action-link元素
      if ($body.find('[data-testid="cell-0-operate"] > [data-testid="suspend-alarm-link"]').length) {
        cy.get('[data-testid="cell-0-operate"] > [data-testid="suspend-alarm-link"]').click();
        cy.get('[data-testid="menu-item-management/suspend-management"] > span').click();
      }
    });
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})