// ***********************************************************
// This example support/e2e.js is processed and
// loaded automatically before your test files.
//
// This is a great place to put global configuration and
// behavior that modifies Cypress.
//
// You can change the location of this file or turn off
// automatically serving support files with the
// 'supportFile' configuration option.
//
// You can read more here:
// https://on.cypress.io/configuration
// ***********************************************************

// Import commands.js using ES2015 syntax:
import './commands'

// Alternatively you can use CommonJS syntax:
// require('./commands')

// 全局配置
Cypress.on('uncaught:exception', (err, runnable) => {
  // 防止Cypress因为应用程序的未捕获异常而失败
  return false
})

// 全局API异常收集
beforeEach(() => {
  // 在每个测试开始前启动API异常收集
  cy.startAPIErrorCollection()
})

afterEach(() => {
  // 在每个测试结束后将API错误信息整合到测试报告中
  cy.integrateAPIErrorsToTestReport()
})

// 通用的登录命令
Cypress.Commands.add('login', (username, password) => {
  const user = username || Cypress.env('username')
  const pass = password || Cypress.env('password')
  
  cy.get('[data-testid="login-username-input"]').type(user)
  cy.get('[data-testid="login-password-input"]').type(pass)
  cy.get('[data-testid="login-captcha-input"]').type('8888')
  cy.get('[data-testid="login-submit-button"]').click()
})

// 通用的导航命令
Cypress.Commands.add('navigateTo', (menuTestId) => {
  cy.get(`[data-testid="${menuTestId}"]`).click()
})

// 通用的表单填写命令
Cypress.Commands.add('fillForm', (formData) => {
  Object.keys(formData).forEach(field => {
    cy.get(`[data-testid="${field}"]`).type(formData[field])
  })
})

// 通用的表单提交命令
Cypress.Commands.add('submitForm', (buttonTestId) => {
  cy.get(`[data-testid="${buttonTestId}"]`).click()
})

// 通用的数据验证命令
Cypress.Commands.add('verifyData', (selector, expectedValue) => {
  cy.get(selector).should('contain.text', expectedValue)
})

// 等待页面加载完成
Cypress.Commands.add('waitForPageLoad', () => {
  cy.get('body').should('be.visible')
  cy.wait(500) // 额外等待500ms确保页面完全加载
})

// 检查数据加载
Cypress.Commands.add('waitForDataLoad', (selector, timeout = 10000) => {
  cy.get(selector, { timeout }).should('be.visible')
})